
    <h1><?php echo ($title ? $title : "Produkty") ?></h1>

    <p><a class="btn btn-success btn-sm" href="?controller=product&action=create">Přidat produkt</a></p>

    <table class="table table-striped">
    <thead>
        <tr><th>ID</th><th>Název</th><th>Kategorie</th><th>Cena</th><th>Skladem</th><th>Dodavatel</th><th>Akce</th></tr>
    </thead>
    <tbody>
    <?php foreach($products as $p): ?>
        <tr>
        <td><?=htmlspecialchars($p->id)?></td>
        <td><?=htmlspecialchars($p->name)?></td>
        <td><?=htmlspecialchars($p->category)?></td>
        <td><?=number_format((float)$p->price, 2, ',', ' ')?></td>
        <td><?=htmlspecialchars($p->stock)?></td>
        <td><?=htmlspecialchars($p->supplier_name ?? '-')?></td>
        <td>
            <a class="btn btn-info" href="?controller=product&action=show&id=<?= $p->id ?>">Zobrazit</a> |
            <a class="btn btn-warning" href="?controller=product&action=edit&id=<?= $p->id ?>">Upravit</a> |
            <a class="btn btn-danger" href="?controller=product&action=delete&id=<?= $p->id ?>" onclick="return confirm('Opravdu smazat?')">Smazat</a>
        </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
    </table>
