<?php

//TODO oddělit CSS
//poslat terapeutky přes bookingController ne tady
$therapists = $therapists ?? [
  ['id' => 'jana', 'name' => 'Jana'],
  ['id' => 'katerina', 'name' => 'Kateřina'],
  ['id' => 'petra', 'name' => 'Petra'],
];

$hours = range(9, 18);
?>

<h1>Vyber termín</h1>

<style>
.calendar { max-width: 420px; margin: 0 auto; }
.cal-header {
  display:flex; justify-content: space-between; align-items:center;
  font-size: 18px; margin-bottom: 10px;
}
.cal-header button {
  background:none; border:0; font-size: 20px; cursor:pointer;
}
.cal-grid {
  display:grid;
  grid-template-columns: repeat(7, 1fr);
  gap: 6px;
}
.cal-day, .cal-week {
  text-align:center; padding:8px; font-size:14px;
}
.cal-week { font-weight:600; color:#555; }
.cal-day {
  border-radius: 10px;
  cursor:pointer;
}
.cal-day:hover { background:#eef2ff; }
.cal-day.selected {
  background:#2f6fed; color:white;
}
.cal-day.disabled {
  color:#bbb; cursor:not-allowed;
}

.section { margin-top: 20px; }
select {
  width:100%; padding:10px; border-radius:10px;
}

.times { display:flex; flex-wrap:wrap; gap:8px; margin-top:8px; }
.time-btn {
  padding:8px 10px; border-radius:10px;
  border:1px solid #ccc; cursor:pointer;
}
.time-btn.active {
  background:#2f6fed; color:white; border-color:#2f6fed;
}

.actions { margin-top:20px; text-align:right; }
button.next {
  background:#2f6fed; color:white;
  border:0; padding:12px 16px; border-radius:12px;
}
button:disabled { opacity:.4; cursor:not-allowed; }
</style>

<form method="post" action="index.php?controller=booking&action=step1Post">
  <input type="hidden" name="date" id="date">
  <input type="hidden" name="time" id="time">

  <!-- KALENDÁŘ -->
  <div class="calendar">
    <div class="cal-header">
      <button type="button" id="prev">‹</button>
      <strong id="monthLabel"></strong>
      <button type="button" id="next">›</button>
    </div>

    <div class="cal-grid" id="calendar"></div>
  </div>

  <!-- MASÉRKA -->
  <div class="section">
    <label>Masérka</label>
    <select name="therapist" id="therapist" required>
      <option value="">Vyber masérku</option>
      <?php foreach ($therapists as $t): ?>
        <option value="<?= $t['id'] ?>"><?= $t['name'] ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <!-- ČASY -->
  <div class="section">
    <label>Čas</label>
    <div class="times" id="times">
      <?php foreach ($hours as $h): 
        $t = str_pad($h,2,'0',STR_PAD_LEFT).':00'; ?>
        <button type="button" class="time-btn" data-time="<?= $t ?>"><?= $t ?></button>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="actions">
    <button class="next" type="submit" id="nextBtn" disabled>Další</button>
  </div>
</form>

<script>
const cal = document.getElementById('calendar');
const label = document.getElementById('monthLabel');
const dateInput = document.getElementById('date');
const timeInput = document.getElementById('time');
const nextBtn = document.getElementById('nextBtn');

let current = new Date();
current.setDate(1);

const weekdays = ['Po','Út','St','Čt','Pá','So','Ne'];
const months = ['Leden','Únor','Březen','Duben','Květen','Červen','Červenec','Srpen','Září','Říjen','Listopad','Prosinec'];

function render() {
  cal.innerHTML = '';
  label.textContent = months[current.getMonth()] + ' ' + current.getFullYear();

  weekdays.forEach(d=>{
    const w=document.createElement('div');
    w.textContent=d; w.className='cal-week';
    cal.appendChild(w);
  });

  let firstDay = new Date(current);
  let start = (firstDay.getDay()+6)%7;

  for(let i=0;i<start;i++) cal.appendChild(document.createElement('div'));

  let days = new Date(current.getFullYear(), current.getMonth()+1, 0).getDate();

  for(let d=1; d<=days; d++){
    const cell = document.createElement('div');
    cell.textContent = d;
    cell.className='cal-day';

    const date = new Date(current.getFullYear(), current.getMonth(), d);
    const today = new Date(); today.setHours(0,0,0,0);

    if(date < today){
      cell.classList.add('disabled');
    } else {
      cell.onclick = ()=>{
        document.querySelectorAll('.cal-day').forEach(x=>x.classList.remove('selected'));
        cell.classList.add('selected');
        dateInput.value = date.toISOString().split('T')[0];
        updateState();
      };
    }

    cal.appendChild(cell);
  }
}

function updateState(){
  nextBtn.disabled = !(dateInput.value && timeInput.value && document.getElementById('therapist').value);
}

document.querySelectorAll('.time-btn').forEach(b=>{
  b.onclick=()=>{
    document.querySelectorAll('.time-btn').forEach(x=>x.classList.remove('active'));
    b.classList.add('active');
    timeInput.value=b.dataset.time;
    updateState();
  };
});

document.getElementById('therapist').onchange = updateState;
document.getElementById('prev').onclick=()=>{ current.setMonth(current.getMonth()-1); render(); };
document.getElementById('next').onclick=()=>{ current.setMonth(current.getMonth()+1); render(); };

render();
</script>
