<?php
function splitDateTime(?string $dt): array {
    if (!$dt) return ['', ''];

    $parts = preg_split('/\s+/', trim($dt));
    $date = $parts[0] ?? '';
    $time = $parts[1] ?? '';
    if (strlen($time) >= 5) $time = substr($time, 0, 5);
    return [$date, $time];
}
?>

<style>
  .topbar { display:flex; justify-content:space-between; align-items:center; gap:12px; margin-bottom: 14px; }
  .btn-link { display:inline-block; padding: 10px 14px; border-radius: 10px; background:#2f6fed; color:#fff; }
  .btn-link:hover { opacity:.92; }

  table { width:100%; border-collapse: collapse; margin-top: 10px; font-size: 14px; }
  th, td { padding: 10px; border-bottom: 1px solid #e7e9f3; vertical-align: top; }
  th { text-align:left; color:#334; background:#f3f5ff; font-weight: 600; }
  tr:hover td { background:#fafbff; }

  .actions { display:flex; gap:10px; align-items:center; flex-wrap: wrap; }
  .btn-small { padding: 8px 10px; border-radius: 10px; border: 1px solid #d9dbe7; background:#fff; cursor:pointer; }
  .btn-danger { border-color:#ffb3b3; background:#fff5f5; }
  .muted { color:#667; font-size: 13px; }

.table-wrapper {
    width: 100%;
    max-height: 60vh;    
    overflow: auto;        
    border-radius: 14px;
}

</style>

<div class="topbar">
  <div>
    <h1 style="margin:0 0 4px;">Přehled rezervací</h1>
  </div>

  <a class="btn-link" href="index.php?controller=booking&action=step1">+ Nová rezervace</a>
</div>

<?php if (empty($reservations)): ?>
  <p class="muted">Zatím žádné rezervace.</p>
<?php else: ?>
  <div class="table-wrapper">
  <table>
    <thead>
      <tr>
        <th>ID</th>
        <th>Jméno</th>
        <th>E-mail</th>
        <th>Telefon</th>
        <th>Masér/ka</th>
        <th>Datum</th>
        <th>Čas</th>
        <th>Poznámka</th>
        <th>Akce</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($reservations as $r): ?>
        <?php [$date, $time] = splitDateTime($r['datetime'] ?? ''); ?>
        <tr>
          <td><?= (int)($r['id'] ?? 0) ?></td>
          <td><?= htmlspecialchars($r['name'] ?? '') ?></td>
          <td><?= htmlspecialchars($r['email'] ?? '') ?></td>
          <td><?= htmlspecialchars($r['phone'] ?? '') ?></td>
          <td><?= htmlspecialchars($r['therapist'] ?? '') ?></td>
          <td><?= htmlspecialchars($date) ?></td>
          <td><?= htmlspecialchars($time) ?></td>
          <td><?= htmlspecialchars($r['note'] ?? '') ?></td>
          <td>
            <div class="actions">
              <a class="btn-small" href="index.php?controller=booking&action=show&id=<?= (int)$r['id'] ?>">Detail</a>
              <a class="btn-small" href="index.php?controller=booking&action=edit&id=<?= (int)$r['id'] ?>">Úprava</a>

              <form method="post" action="index.php?controller=booking&action=destroy" style="margin:0;"
                    onsubmit="return confirm('Opravdu smazat rezervaci #<?= (int)$r['id'] ?>?');">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="btn-small btn-danger" type="submit">Smazat</button>
              </form>
            </div>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
    </table>
</div>
<?php endif; ?>
