<?php
use Carbon\Carbon;

// 1. Prepare the tasks for JavaScript
// FullCalendar expects 'title' and 'start' (date) fields.
$events = [];
foreach ($tasks as $task) {
    $events[] = [
            'id'    => $task['id'],
            'title' => $task['title'],
            'start' => $task['due_date'],
            'className' => $task['is_completed'] ? 'task-done' : 'task-pending',
        // Optional: Add a custom URL for clicking the event
            'url'   => '/complete?id=' . $task['id']
    ];
}
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <title>Kalendář Úkolů</title>
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.js'></script>

    <style>
        body { font-family: sans-serif; padding: 20px; }
        #calendar { max-width: 900px; margin: 0 auto; }

        /* Custom styling for completed tasks */
        .task-done { text-decoration: line-through; opacity: 0.6; background-color: #28a745 !important; border-color: #28a745 !important; }
        .task-pending { background-color: #007bff; border-color: #007bff; }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                locale: 'cs', // Set language to Czech
                firstDay: 1,  // Start week on Monday
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek'
                },
                // 2. Feed the PHP array into JS
                events: <?php echo json_encode($events); ?>,

                // Handle clicking a task
                eventClick: function(info) {
                    if (info.event.url) {
                        if(!confirm("Označit úkol jako hotový?")) {
                            info.jsEvent.preventDefault();
                        }
                    }
                }
            });
            calendar.render();
        });
    </script>
</head>
<body>

<div id='calendar'></div>

</body>
</html>