<?php

namespace App\Core;
use mysqli;

class Database
{
    private string $host = "dmp-korero.fun";
    private string $user;
    private string $password;
    private string $database = "dmp";

    public mysqli $conn;

    public function __construct()
    {
        $env = @parse_ini_file(__DIR__ . '/../../config/.env', true);
        if (!$env)
        {
            echo json_encode(['status' => 'error', 'message' => 'Config soubor chybí, nebo je k němu špatná cesta']);
            exit;
        }

        $this->user = $env["USERNAME"];
        $this->password = $env["PASSWORD"];

        $this->conn = new mysqli($this->host, $this->user, $this->password, $this->database);
    }

    public function getConnection(): mysqli
    {
        return $this->conn;
    }
}
?>