<?php
namespace App\Controllers;

use App\Model\Task;

class TaskController
{
    private Task $taskModel;

    public function __construct($conn)
    {
        $this->taskModel = new Task($conn);
    }

    public function index(): void
    {
        $tasks = $this->taskModel->getAllTasks();

        require __DIR__ . '/../Views/index.php';
    }

    public function addTask(Task $task): void
    {
        $tasks = $this->taskModel->addTask($task);
    }

    public function updateTask(Task $task, int $task_id): void
    {
        $tasks = $this->taskModel->updateTask($task, $task_id);
    }

    public function deleteTask(int $task_id): void
    {
        $tasks = $this->taskModel->deleteTask($task_id);
    }
}