-- Adminer 4.8.1 MySQL 5.7.27-0ubuntu0.16.04.1 dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) COLLATE utf8_czech_ci NOT NULL,
  `email` varchar(150) COLLATE utf8_czech_ci DEFAULT NULL,
  `phone` varchar(50) COLLATE utf8_czech_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8_czech_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

INSERT INTO `customers` (`id`, `name`, `email`, `phone`, `address`, `created_at`) VALUES
(5,	'Karel Novák',	'karelnovak@gmail.com',	'11155666',	'Ostrov, Hlavní 15',	'2026-01-16 07:07:48');

DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) COLLATE utf8_czech_ci NOT NULL,
  `category` enum('ovoce','zelenina','orechy') COLLATE utf8_czech_ci NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `stock` int(11) NOT NULL DEFAULT '0',
  `supplier_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `products_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

INSERT INTO `products` (`id`, `name`, `category`, `price`, `stock`, `supplier_id`, `created_at`) VALUES
(10,	'Jablko Golden',	'ovoce',	25.50,	100,	11,	'2026-01-16 07:07:15'),
(11,	'Mrkev',	'zelenina',	12.00,	50,	12,	'2026-01-16 07:07:15'),
(12,	'Burák',	'orechy',	12.00,	500,	12,	'2026-01-16 07:08:27');

DROP TABLE IF EXISTS `suppliers`;
CREATE TABLE `suppliers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) COLLATE utf8_czech_ci NOT NULL,
  `email` varchar(150) COLLATE utf8_czech_ci DEFAULT NULL,
  `phone` varchar(50) COLLATE utf8_czech_ci DEFAULT NULL,
  `vip` tinyint(4) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

INSERT INTO `suppliers` (`id`, `name`, `email`, `phone`, `vip`, `created_at`) VALUES
(11,	'Zahradnictví Novák',	'novak@example.com',	'+420601123456',	1,	'2026-01-16 07:06:14'),
(12,	'Bio Farma',	'info@biofarma.cz',	'+420602987654',	0,	'2026-01-16 07:06:14');

-- 2026-01-16 07:10:58
