    <h1>Upravit produkt</h1>

    <form method="post" action="">
        <div class="mb-3">
            <label class="form-label">Název:</label>
            <input class="form-control" name="name" type="text" value="<?=htmlspecialchars($product->name)?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Kategorie:</label>
            <select class="form-select" name="category">
                <option value="ovoce" <?= ($product->category === 'ovoce') ? 'selected' : '' ?>>Ovoce</option>
                <option value="zelenina" <?= ($product->category === 'zelenina') ? 'selected' : '' ?>>Zelenina<option>
                <option value="orechy" <?= ($product->category === 'orechy') ? 'selected' : '' ?>>Ořechy<option>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Cena (CZK):</label>
            <input class="form-control" name="price" type="number" step="0.01" value="<?=htmlspecialchars($product->price)?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Sklad (ks):</label>
            <input class="form-control" name="stock" type="number" value="<?=htmlspecialchars($product->stock)?>" required>
        </div>


        <div class="mb-3">
            <label class="form-label">Dodavatel:</label>
            <select class="form-select" name="supplier_id">
                <option value="">-- bez dodavatele --</option>
                <?php foreach($suppliers as $s): ?>
                    <option value="<?= $s->id ?>" <?= ($product->supplier_id == $s->id) ? 'selected' : '' ?>><?= htmlspecialchars($s->name) ?></option>
                <?php endforeach; ?>
            </select>
            
        </div>


    <button class="btn btn-success" type="submit"><i class="bi bi-floppy"></i></button>
    <a class="btn btn-outline-secondary" href="?controller=product&action=index"><i class="bi bi-arrow-90deg-left"></i></a>
    </form>
