<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="/css/styles.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <link rel="stylesheet" href="https://cdn.datatables.net/2.3.4/css/dataTables.dataTables.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css">
  <title>Ukázková aplikace</title>
</head>
<body>
  <header style="margin-bottom:16px;">
    <nav class="navbar navbar-expand-lg px-lg-3 py-3" style="background-color: #c5aa6a;border-bottom: 1px solid #00000022;">
        <div class="container-fluid">
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">Produkty</a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="?controller=product&action=index">Všechno</a></li>
                        <li><a class="dropdown-item" href="?controller=product&action=ovoce">Ovoce</a></li>
                        <li><a class="dropdown-item" href="?controller=product&action=zelenina">Zelenina</a></li>
                        <li><a class="dropdown-item" href="?controller=product&action=orechy">Ořechy</a></li>
                    </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link<?php if ($current == '?controller=supplier&action=index') echo ' active'; ?>" href="?controller=supplier&action=index">Dodavatelé</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link<?php if ($current == '?controller=customer&action=index') echo ' active'; ?>" href="?controller=customer&action=index">Zákazníci</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
  </header>
  <div class="container pb-5">  
    <main>
        <?php
        // $file je nastaven ve View::render() — obsahuje cestu k šabloně
        if (isset($file) && file_exists($file)) {
            include $file;
        } else {
            echo '<p>Šablona nebyla nalezena.</p>';
        }
        ?>
    </main>
    </div>  

  <footer class="fixed-bottom text-center bg-dark text-white">
    <p>Ukázka MVC principu.</p>
  </footer>
  
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/2.3.4/js/dataTables.js"></script>

    <script>
        new DataTable('#TableProducts', {
            info: false,
            paging: false,
            searching: false,
        });
    </script>
        <script>
        new DataTable('#TableSuppliers', {
            info: false,
            paging: false,
            searching: false,
        });
    </script>
</body>
</html>