<?php
/**
 * Public/index.php
 * Hlavní vstupní bod aplikace
 * Načítá bootstrap, konfiguraci a routuje požadavky
 */

// Spustit sessions
session_start();

// Načíst autoloader a helper
require __DIR__ . '/../app/bootstrap.php';

use App\Core\Database;
use App\Controllers\CalendarController;

try {
    // Získat config a vytvořit DB připojení
    $cfg = config();
    $db = new Database($cfg['db']);

    // Určit akci (GET parametr)
    $action = $_GET['action'] ?? 'index';

    // Vytvořit controller a zavolat akci
    $controller = new CalendarController($db);

    // Ověřit, že metoda existuje
    if (method_exists($controller, $action)) {
        $controller->$action();
    } else {
        // Fallback na index
        $controller->index();
    }

} catch (\Exception $e) {
    // Chyba při spuštění
    http_response_code(500);
    echo '<div class="container mt-5"><div class="alert alert-danger">';
    echo '<h4>Chyba aplikace</h4>';
    echo '<p>' . htmlspecialchars($e->getMessage()) . '</p>';
    echo '</div></div>';
    error_log('App Error: ' . $e->getMessage());
}
?>

