-- Tabulka pro správu rezervací ledu v MVC kalendáři
CREATE TABLE IF NOT EXISTS rezervace (
    id INT AUTO_INCREMENT PRIMARY KEY,
    date DATE NOT NULL,
    hour_start TINYINT NOT NULL,       -- 0–23, začátek rezervace
    hour_end TINYINT NOT NULL,          -- 0–23, konec rezervace
    title VARCHAR(255) NOT NULL,        -- název rezervace (např. "Trénink juniorů")
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY unique_hour_conflict (date, hour_start, hour_end)
);

-- Poznámka: U UNIQUE klíče nad (date, hour_start, hour_end) nelze vložit
-- dvě rezervace na stejný den se overlappingem hodin.
-- Pro správná data to lze zajistit také aplikační logikou.
