<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="/css/styles.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <title>Kalendář Zimního Stadionu</title>
</head>
<body>
  <header class="bg-primary text-white py-3 mb-4">
    <div class="container">
      <h1 class="mb-0">
        <i class="bi bi-calendar-event"></i> Kalendář Zimního Stadionu
      </h1>
    </div>
  </header>

  <div class="container pb-5">
    <!-- Zprávy: úspěch/chyba -->
    <?php if (isset($_SESSION['success'])): ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($_SESSION['success']) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
      <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <?php if (isset($_SESSION['error'])): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($_SESSION['error']) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
      <?php unset($_SESSION['error']); ?>
    <?php endif; ?>

    <main>
      <?php
      // $file je nastaven ve View::render() — obsahuje cestu k šabloně
      if (isset($file) && file_exists($file)) {
          include $file;
      } else {
          echo '<p class="alert alert-warning">Šablona nebyla nalezena.</p>';
      }
      ?>
    </main>
  </div>

  <footer class="bg-dark text-white text-center py-3 mt-5">
    <p class="mb-0">Správa rezervací ledu – Zimní stadion © 2024</p>
  </footer>
</body>
</html>
