<div class="row">
  <!-- Navigace mezi dny -->
  <div class="col-12 mb-4">
    <div class="d-flex justify-content-between align-items-center">
      <a href="<?php $prev = date('Y-m-d', strtotime($date . ' -1 day')); ?>?date=<?= $prev ?>" class="btn btn-secondary">
        <i class="bi bi-chevron-left"></i> Předchozí
      </a>
      <h2><?= date('d. m. Y (l)', strtotime($date)) ?></h2>
      <a href="<?php $next = date('Y-m-d', strtotime($date . ' +1 day')); ?>?date=<?= $next ?>" class="btn btn-secondary">
        Další <i class="bi bi-chevron-right"></i>
      </a>
    </div>
  </div>

  <!-- Tlačítko pro novou rezervaci -->
  <div class="col-12 mb-4">
    <a href="?action=create&date=<?= $date ?>" class="btn btn-success btn-lg">
      <i class="bi bi-plus-circle"></i> Nová rezervace
    </a>
  </div>

  <!-- Tabulka hodin -->
  <div class="col-12">
    <table class="table table-bordered table-hover">
      <thead class="table-dark">
        <tr>
          <th width="15%">Čas</th>
          <th width="65%">Stav</th>
          <th width="20%">Akce</th>
        </tr>
      </thead>
      <tbody>
        <?php for ($h = 6; $h <= 22; $h++): ?>
          <tr class="<?= isset($reserved[$h]) ? 'table-danger' : 'table-light' ?>">
            <td class="fw-bold">
              <?= str_pad($h, 2, '0', STR_PAD_LEFT) ?>:00 – <?= str_pad($h+1, 2, '0', STR_PAD_LEFT) ?>:00
            </td>
            <td>
              <?php if (isset($reserved[$h])): ?>
                <?php $res = $reserved[$h]; ?>
                <span class="badge bg-danger">
                  <i class="bi bi-lock-fill"></i>
                  <?= htmlspecialchars($res->title) ?>
                </span>
                <br>
                <small class="text-muted">
                  <?= $res->getTimeRange() ?>
                </small>
              <?php else: ?>
                <span class="badge bg-success"><i class="bi bi-check-circle"></i> Volné</span>
              <?php endif; ?>
            </td>
            <td>
              <?php if (isset($reserved[$h])): ?>
                <a href="?action=edit&id=<?= $reserved[$h]->id ?>" class="btn btn-sm btn-success" title="Editovat">
                  <i class="bi bi-pencil"></i> Upravit
                </a>
                <a href="?action=delete&id=<?= $reserved[$h]->id ?>" 
                   class="btn btn-sm btn-danger"
                   onclick="return confirm('Smazat tuto rezervaci?');"
                   title="Smazat">
                  <i class="bi bi-trash"></i> Smazat
                </a>
              <?php else: ?>
                <a href="?action=create&date=<?= $date ?>&start=<?= $h ?>" class="btn btn-sm btn-primary">
                  <i class="bi bi-plus"></i> Rezervovat
                </a>
              <?php endif; ?>
            </td>
          </tr>
        <?php endfor; ?>
      </tbody>
    </table>
  </div>

  <!-- Přehled všech rezervací -->
  <div class="col-12 mt-5">
    <h3>Přehled rezervací na tento den</h3>
    <?php if (empty($reservations)): ?>
      <p class="alert alert-info">Žádné rezervace na tento den.</p>
    <?php else: ?>
      <table class="table">
        <thead class="table-light">
          <tr>
            <th>Čas</th>
            <th>Název</th>
            <th>Vytvořeno</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($reservations as $res): ?>
            <tr>
              <td class="fw-bold">
                <?= $res->getTimeRange() ?>
              </td>
              <td><?= htmlspecialchars($res->title) ?></td>
              <td>
                <small class="text-muted">
                  <?= $res->getCreatedAtFormatted() ?>
                </small>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>
</div>


