<div class="row">
  <div class="col-md-6">
    <h2><?= $mode === 'create' ? 'Nová rezervace' : 'Úprava rezervace' ?></h2>

    <form method="post" action="<?= $mode === 'create' ? '?action=store' : '?action=update' ?>">
      <?php if ($mode === 'edit'): ?>
        <input type="hidden" name="id" value="<?= $reservation->id ?>">
      <?php endif; ?>

      <!-- Datum -->
      <div class="mb-3">
        <label for="date" class="form-label">Datum</label>
        <input type="date" class="form-control" id="date" name="date" 
               value="<?= $date ?>" required <?= $mode === 'edit' ? 'readonly' : '' ?>>
      </div>

      <!-- Čas začátku -->
      <div class="mb-3">
        <label for="hour_start" class="form-label">Začátek (hodina)</label>
        <select class="form-select" id="hour_start" name="hour_start" required onchange="updateEndOptions()">
          <option value="">-- Vyberte --</option>
          <?php for ($h = 6; $h <= 22; $h++): ?>
            <option value="<?= $h ?>" 
                    <?= ($mode === 'edit' && $reservation->hour_start == $h) ? 'selected' : '' ?>
                    <?= isset($reserved[$h]) && ($mode !== 'edit' || $reservation->id != $reserved[$h]->id) ? 'disabled' : '' ?>>
              <?= str_pad($h, 2, '0', STR_PAD_LEFT) ?>:00
              <?php if (isset($reserved[$h]) && ($mode !== 'edit' || $reservation->id != $reserved[$h]->id)): ?>
                (obsazeno)
              <?php endif; ?>
            </option>
          <?php endfor; ?>
        </select>
        <small class="form-text text-muted">Vyberte čas zahájení</small>
      </div>

      <!-- Čas konce -->
      <div class="mb-3">
        <label for="hour_end" class="form-label">Konec (hodina)</label>
        <select class="form-select" id="hour_end" name="hour_end" required>
          <option value="">-- Vyberte --</option>
          <?php for ($h = 7; $h <= 23; $h++): ?>
            <option value="<?= $h ?>"
                    <?= ($mode === 'edit' && $reservation->hour_end == $h) ? 'selected' : '' ?>>
              <?= str_pad($h, 2, '0', STR_PAD_LEFT) ?>:00
            </option>
          <?php endfor; ?>
        </select>
        <small class="form-text text-muted">Vyberte čas ukončení (musí být po zahájení)</small>
      </div>

      <!-- Název/Popis -->
      <div class="mb-3">
        <label for="title" class="form-label">Název rezervace</label>
        <input type="text" class="form-control" id="title" name="title" 
               placeholder="Např.: Trénink juniorů, Zápas, Veřejná bruslení..."
               value="<?= $mode === 'edit' ? htmlspecialchars($reservation->title) : '' ?>"
               required>
      </div>

      <!-- Tlačítka -->
      <div class="d-flex gap-2">
        <button type="submit" class="btn btn-<?= $mode === 'create' ? 'success' : 'warning' ?>">
          <i class="bi bi-check-circle"></i>
          <?= $mode === 'create' ? 'Vytvořit rezervaci' : 'Uložit změny' ?>
        </button>
        <a href="?date=<?= $date ?>" class="btn btn-secondary">
          <i class="bi bi-x-circle"></i> Zrušit
        </a>
      </div>
    </form>

    <!-- Odpočet volných hodin -->
    <div class="mt-5 alert alert-info">
      <h5>Přehled dostupnosti</h5>
      <p class="mb-0">
        <strong>Otevírací doba:</strong> 6:00 – 23:00<br>
        <strong>Volné hodiny dnes:</strong> 
        <?php 
          $free = 0;
          for ($h = 6; $h <= 22; $h++) {
            if (!isset($reserved[$h])) $free++;
          }
          echo $free;
        ?> hodin
      </p>
    </div>
  </div>

  <!-- Nápověda -->
  <div class="col-md-6">
    <div class="card">
      <div class="card-header bg-light">
        <h5 class="card-title mb-0">Nápověda</h5>
      </div>
      <div class="card-body">
        <h6>Jak vytvořit rezervaci?</h6>
        <ol>
          <li>Vyberte <strong>počáteční hodinu</strong></li>
          <li>Vyberte <strong>koncovou hodinu</strong> (musí být později)</li>
          <li>Zadejte <strong>název</strong> rezervace (např. typ tréninku)</li>
          <li>Klikněte <strong>Vytvořit</strong></li>
        </ol>

        <h6 class="mt-3">Poznámky</h6>
        <ul>
          <li>Obsazené hodiny jsou <span class="badge bg-danger">zablokované</span></li>
          <li>Rezervace se nesmí překrývat</li>
          <li>Stanice je otevřena <strong>6:00 – 23:00</strong></li>
        </ul>
      </div>
    </div>

    <!-- Grafický přehled -->
    <div class="card mt-3">
      <div class="card-header bg-light">
        <h5 class="card-title mb-0">Dostupnost dnes</h5>
      </div>
      <div class="card-body" style="font-size: 0.85rem;">
        <div class="d-flex flex-wrap gap-1">
          <?php for ($h = 6; $h <= 22; $h++): ?>
            <span class="badge <?= isset($reserved[$h]) ? 'bg-danger' : 'bg-success' ?>" title="<?= str_pad($h, 2, '0', STR_PAD_LEFT) ?>:00">
              <?= str_pad($h, 2, '0', STR_PAD_LEFT) ?>
            </span>
          <?php endfor; ?>
        </div>
        <p class="mt-3 mb-0">
          <span class="badge bg-success">Volné</span>
          <span class="badge bg-danger">Obsazené</span>
        </p>
      </div>
    </div>
  </div>
</div>

<script>
function updateEndOptions() {
  const startSelect = document.getElementById('hour_start');
  const endSelect = document.getElementById('hour_end');
  const startValue = parseInt(startSelect.value);

  // Vymazat stávající možnosti
  while (endSelect.options.length > 1) {
    endSelect.remove(1);
  }

  if (startValue) {
    for (let h = startValue + 1; h <= 23; h++) {
      const option = document.createElement('option');
      option.value = h;
      option.textContent = String(h).padStart(2, '0') + ':00';
      endSelect.appendChild(option);
    }
  }
}

// Inicializace při načtení
window.addEventListener('DOMContentLoaded', function() {
  updateEndOptions();
});
</script>

