-- Příklady SQL příkazů pro testování aplikace

-- Vymažeme všechny rezervace (POZOR!)
-- DELETE FROM rezervace;

-- Vloží testovací rezervaci
INSERT INTO rezervace (date, hour_start, hour_end, title, created_at) 
VALUES (CURDATE(), 8, 10, 'Trénink juniorů', NOW());

-- Vloží druhou rezervaci
INSERT INTO rezervace (date, hour_start, hour_end, title, created_at) 
VALUES (CURDATE(), 14, 16, 'Trénink seniorů', NOW());

-- Vloží třetí rezervaci
INSERT INTO rezervace (date, hour_start, hour_end, title, created_at) 
VALUES (CURDATE(), 18, 20, 'Veřejná bruslení', NOW());

-- Zobrazí všechny rezervace
SELECT * FROM rezervace ORDER BY date DESC, hour_start;

-- Zobrazí rezervace pro dnešní den
SELECT * FROM rezervace WHERE date = CURDATE() ORDER BY hour_start;

-- Zobrazí rezervace na konkrétní den
SELECT * FROM rezervace WHERE date = '2024-02-09' ORDER BY hour_start;

-- Pokus vytvořit konfliktní rezervaci (mělo by selhat aplikací)
-- Pokud by bylo hour_end > hour_start a čas se nepřekrývá, vloží se OK
INSERT INTO rezervace (date, hour_start, hour_end, title)
VALUES (CURDATE(), 10, 14, 'Zápas'); 
-- V tomto případě konflikt s 'Trénink juniorů' (8-10) - OK
-- Ale konflikt s 'Trénink seniorů' (14-16) - ÉHM, 14 je v rozsahu, takže bez konfliktu!

-- Zobrazí počet rezervací na konkrétní den
SELECT COUNT(*) as pocet FROM rezervace WHERE date = CURDATE();

-- Zobrazí volné hodiny na konkrétní den (6-23)
-- Toto je komplexnější dotaz - najde všechny objednané hodiny
SELECT * FROM rezervace WHERE date = CURDATE() AND hour_start >= 6 AND hour_end <= 23;

-- Upravit existující rezervaci
UPDATE rezervace SET title = 'Upravený název' WHERE id = 1;

-- Smazat konkrétní rezervaci
DELETE FROM rezervace WHERE id = 1;

-- Kontrola struktury tabulky
DESCRIBE rezervace;

-- Zobrazí všechny rezervace seřazené podle data a času
SELECT DATE_FORMAT(date, '%d.%m.%Y') as den, 
       CONCAT(LPAD(hour_start, 2, '0'), ':00') as zacatek,
       CONCAT(LPAD(hour_end, 2, '0'), ':00') as konec,
       title
FROM rezervace
ORDER BY date DESC, hour_start;
