# Kalendář Zimního Stadionu

Jednoduchá MVC aplikace v PHP pro správu rezervací ledu. Umožňuje spravovat hodinové sloty rezervací pro jeden zimní stadion.

## Požadavky

- PHP 7.4 nebo vyšší
- MySQL 5.7 nebo vyšší
- Webový server (Apache, nginx, PHP built-in server, apod.)

## Instalace

### 1. Klonování / Zkopírování projektu
```bash
cd e:\w\havlja2\I4\kalendar-mvc
```

### 2. Vytvoření databáze

Spusťte SQL skript pro vytvoření tabulky:
```sql
CREATE TABLE IF NOT EXISTS rezervace (
    id INT AUTO_INCREMENT PRIMARY KEY,
    date DATE NOT NULL,
    hour_start TINYINT NOT NULL,       -- 0–23, začátek rezervace
    hour_end TINYINT NOT NULL,          -- 0–23, konec rezervace
    title VARCHAR(255) NOT NULL,        -- název rezervace
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY unique_hour_conflict (date, hour_start, hour_end)
);
```

Nebo importujte soubor `create_table.sql`:
```bash
mysql -u username -p database_name < create_table.sql
```

### 3. Konfiguraci databáze

Otevřete `app/config.php` a nastavte připojení k MySQL:
```php
return [
    'db' => [
        'host' => 'localhost',
        'dbname' => 'vas_databaze',
        'user' => 'vas_uzivatel',
        'pass' => 'vase_heslo',
        'charset' => 'utf8mb4'
    ]
];
```

**Alternativa:** Pokud používáte `spso.mysql.ini`, konfigurační soubor jej automaticky načte.

### 4. Spuštění aplikace

#### Pomocí PHP built-in serveru:
```bash
cd public
php -S localhost:8000
```

Poté otevřete v prohlížeči: **http://localhost:8000**

#### Pomocí Apache/nginx:
Nastavte DocumentRoot na složku `public/`.

## Struktura projektu

```
kalendar-mvc/
├── app/
│   ├── bootstrap.php              # Autoloader a helpery
│   ├── config.php                 # Konfigurační soubor
│   ├── Controllers/
│   │   └── CalendarController.php # Hlavní controller
│   ├── Core/
│   │   ├── Controller.php         # Základní třída controlleru
│   │   ├── Database.php           # Připojení k DB
│   │   ├── Model.php              # Základní třída modelu
│   │   └── View.php               # Renderování šablon
│   ├── Models/
│   │   └── Reservation.php        # Model pro rezervace
│   └── Views/
│       ├── layout.php             # Hlavní šablona
│       └── calendar/
│           ├── index.php          # Zobrazení kalendáře
│           ├── form.php           # Formulář pro rezervaci
│           ├── edit.php           # (nepoužívá se)
│           └── show.php           # (nepoužívá se)
├── public/
│   ├── index.php                  # Vstupní bod aplikace
│   └── css/
│       └── styles.css             # Css styly
└── create_table.sql               # SQL skript pro vytvoření tabulky
```

## Funkčnost

### Hlavní view (Kalendář)
- Zobrazuje hodinové sloty pro vybraný den (6:00 – 23:00)
- Zeleně jsou označeny **volné** sloty
- Červeně jsou označeny **obsazené** sloty
- Navigace mezi dny (Předchozí / Další)

### Vytvoření rezervace
- Kliknutím na **Nová rezervace** nebo **Rezervovat** na volném slotu se otevře formulář
- Vyberte **počáteční hodinu** a **koncovou hodinu**
- Vyberte **název** rezervace (např. "Trénink juniorů")
- Systém automaticky ověří, že se časy nepřekrývají

### Editace rezervace
- Kliknutím na **Upravit** u obsazené hodiny se otevře editor
- Změňte časy nebo název
- Uložte změny

### Mazání rezervace
- Kliknutím na **Smazat** u obsazené hodiny se rezervace smaže
- Potvrzovací dialog zabezpečuje před náhodným smazáním

## Použité technologie

- **PHP 7.4+** – Programovací jazyk
- **MySQL** – Databáze
- **Bootstrap 5** – CSS framework (bez Tailwind!)
- **HTML5 / CSS3** – Frontend
- **Vanilla JavaScript** – Dynamické prvky (bez jQuery!)

## Architektura (MVC)

Aplikace se řídí architekturou **MVC** (Model-View-Controller):

1. **Model** (`app/Models/Reservation.php`)
   - Komunikace s databází
   - Validace dat
   - Detekce konfliktů hodin

2. **View** (`app/Views/calendar/`)
   - Šablony pro zobrazení UI
   - HTML + Bootstrap
   - Formuláře

3. **Controller** (`app/Controllers/CalendarController.php`)
   - Logika aplikace
   - Propojení Model ↔ View
   - Routování akcí

## Routování (URL)

```
/?                          # Zobrazení kalendáře (aktuální den)
/?date=2024-02-09          # Zobrazení kalendáře pro daný den
/?action=create            # Nová rezervace (formulář)
/?action=store             # Uložení nové rezervace (POST)
/?action=edit&id=5         # Editace rezervace (formulář)
/?action=update            # Uložení změn rezervace (POST)
/?action=delete&id=5       # Smazání rezervace
```

## Ověřování konfliktů hodin

Systém používá SQL logiku a PHP validaci:

```php
// Dva časové intervaly se překrývají, pokud:
// start1 < end2 AND start2 < end1

// Příklad:
// Rezervace 1: 10:00 – 12:00
// Rezervace 2: 11:00 – 13:00  → KONFLIKT! (11:00 je v rozsahu 10-12)
// Rezervace 3: 12:00 – 14:00  → OK! (12:00 je mimo rozsah 10-12)
```

## Bezpečnost

- **SQL Injection:** Ochrana pomocí prepared statements
- **XSS:** Ochrana pomocí `htmlspecialchars()`
- **CSRF:** Token by mohl být přidán v budoucnu
- **Bez autentizace:** Projekt je určen pro jednoho uživatele

## Budoucí vylepšení

- [ ] Přidání CSRF tokenů
- [ ] Zakomentovaní a editace popisů rezervací
- [ ] Export rezervací (CSV, PDF)
- [ ] Opakující se rezervace (každý týden apod.)
- [ ] SMS/Email notifikace
- [ ] Vícenásobné zimní stadionu
- [ ] Přihlášení a správa uživatelů

## Autor

Vytvořeno jako školský projekt.

## Licence

MIT License
