<?php
// app/Models/Supplier.php
namespace App\Models;

use App\Core\Database;
use App\Models\Entities\SupplierEntity;

class Supplier extends BaseRepository
{
    public function __construct(Database $db)
    {
        parent::__construct($db, 'suppliers', SupplierEntity::class);
    }

    /**
     * Vytvoří nového dodavatele z pole dat (typicky z formuláře).
     * Vrací id vloženého záznamu.
     *
     * @param array $data
     * @return int
     */
    public function create(array $data): int
    {
        $stmt = $this->pdo->prepare("INSERT INTO suppliers (name, email, phone) VALUES (:name, :email, :phone)");
        $stmt->execute([
            'name'  => $data['name'],
            'email' => $data['email'] ?? null,
            'phone' => $data['phone'] ?? null
        ]);
        return (int)$this->pdo->lastInsertId();
    }

    /**
     * Aktualizuje dodavatele podle id.
     *
     * @param int $id
     * @param array $data
     * @return bool
     */
public function update(int $id, array $data): bool
{
    // Tady ti pravděpodobně chybí ", is_vip=:is_vip"
    $stmt = $this->pdo->prepare("UPDATE suppliers SET name=:name, email=:email, phone=:phone, is_vip=:is_vip WHERE id=:id");
    return $stmt->execute([
        'name'   => $data['name'],
        'email'  => $data['email'] ?? null,
        'phone'  => $data['phone'] ?? null,
        'is_vip' => isset($data['is_vip']) ? 1 : 0, // Tohle tam musí být
        'id'     => $id
    ]);
}
}