<?php
session_start();
require 'database.php';

// Kontrola přihlášení
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: access.php");
    exit;
}

// Kontrola přítomnosti ID
$bikeId = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($bikeId <= 0) {
    echo "Neplatné ID kola.";
    exit;
}

// Načtení aktuálních dat kola
$stmt = $pdo->prepare("SELECT * FROM bikes WHERE id = ?");
$stmt->execute([$bikeId]);
$bike = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$bike) {
    echo "Kolo nebylo nalezeno.";
    exit;
}

// Načtení značek a kategorií pro select
$brands = $pdo->query("SELECT id, Brand FROM brands")->fetchAll(PDO::FETCH_ASSOC);
$categories = $pdo->query("SELECT id, Category FROM categories")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <title>Upravit kolo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h2 class="mb-4">Upravit kolo</h2>

    <form action="admin_save_bike.php" method="post">
        <input type="hidden" name="id" value="<?= $bike['id'] ?>">

        <div class="mb-3">
            <label for="brand_id" class="form-label">Značka</label>
            <select class="form-select" name="brand_id" required>
                <?php foreach ($brands as $brand): ?>
                    <option value="<?= $brand['id'] ?>" <?= $bike['brand_id'] == $brand['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($brand['Brand']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="model" class="form-label">Model</label>
            <input type="text" class="form-control" name="model" value="<?= htmlspecialchars($bike['model']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="price" class="form-label">Cena</label>
            <input type="number" class="form-control" name="price" value="<?= $bike['price'] ?>" required>
        </div>

        <div class="mb-3">
            <label for="color" class="form-label">Barva</label>
            <input type="text" class="form-control" name="color" value="<?= htmlspecialchars($bike['color']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="category_id" class="form-label">Kategorie</label>
            <select class="form-select" name="category_id" required>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>" <?= $bike['category_id'] == $cat['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($cat['Category']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="image_main" class="form-label">Hlavní obrázek (např. bike01)</label>
            <input type="text" class="form-control" name="image_main" value="<?= htmlspecialchars($bike['image_main']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="image_gallery" class="form-label">Galerie obrázků (čárkami oddělené názvy souborů)</label>
            <input type="text" class="form-control" name="image_gallery" value="<?= htmlspecialchars($bike['image_gallery']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="description" class="form-label">Popis</label>
            <textarea class="form-control" name="description" rows="5"><?= htmlspecialchars($bike['description']) ?></textarea>
        </div>

        <button type="submit" class="btn btn-success">Uložit změny</button>
        <a href="admin_dashboard.php" class="btn btn-secondary">Zpět</a>
    </form>
</div>
</body>
</html>
