<?php 
    $server = "websql.in.spsostrov.cz";
    $data = parse_ini_file("../spso.mysql.ini");
    $username = $data["username"];
    $password = $data["password"];
    $database = $data["database"];

    $pdo = new PDO(
        "mysql:host=$server;dbname=$database;charset=utf8mb4", 
        $username, 
        $password
    );

    if(isset($_GET["filtr"])){
        switch($_GET["filtr"]){
            case "nejlevnejsi": $dotaz = "SELECT * FROM jidlo ORDER BY cena"; break;
            case "nejdrazsi": $dotaz = "SELECT * FROM jidlo ORDER BY cena DESC"; break;
            default: $dotaz = "SELECT * FROM jidlo ORDER BY nazev"; break;
        }
    } else {
        $dotaz = "SELECT * FROM jidlo ORDER BY nazev";
    }    
    

    $result = $pdo
                ->query($dotaz)
                ->fetchAll();

    $pdo = null;
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jídelní lístek</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-md-9">
                <h1>Jídelní lístek</h1>
                <?php 
                    foreach($result as $data){
                        if(trim($data["url"]) == "")
                            continue;

                        echo "<div class='row mb-2'>";

                        echo "<div class='col-sm-2'>";
                        echo "<img src='{$data["url"]}' class='w-100'>";
                        echo "</div>";

                        echo "<div class='col-sm-3'>";
                        echo $data["nazev"] . "<br>" . $data["cena"] . " Kč";
                        echo "</div>";

                        echo "<div class='col-sm-7'>";
                        echo $data["popis"];
                        echo "</div>";

                        echo "</div>";
                    }
                ?>
            </div>
            <div class="col-md-3">
                <a href="?filtr=nejlevnejsi" class="btn btn-sm btn-primary">od nejlevnějšího</a>
                <a href="?filtr=nejdrazsi" class="btn btn-sm btn-primary">od nejdražšího</a>
            </div>
        </div>
    </div>
</body>
</html>