<?php 
    $city = urlencode($_GET["city"]);
    $url = "https://wttr.in/$city?lang=cs&format=j1";

    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);  // do proměnné

    $response = curl_exec($curl);
    curl_close($curl);

    // převod na asociativní pole
    $data = json_decode($response, true);

    $aktualni_podminky = $data["current_condition"][0];
    $teplota =  $aktualni_podminky["temp_C"];
    $popis = $aktualni_podminky["lang_cs"][0]["value"] ?? "Popis nedostupný";

    // Získání minimální a maximální teploty
    $pocasi_dnes = $data["weather"][0];
    $minimalni_teplota = $pocasi_dnes["mintempC"] ?? "N/A";
    $maximalni_teplota = $pocasi_dnes["maxtempC"] ?? "N/A";

    $weather = "{$_GET['city']}: $popis $teplota °C";
    $teploty = "Min: $minimalni_teplota °C, Max: $maximalni_teplota °C";

    $lat = $data["nearest_area"][0]["latitude"];
    $long = $data["nearest_area"][0]["longitude"];
    $poloha = "$lat,$long";
?>
<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Počasí</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <h1>Počasí</h1>

        <form style="max-width: 420px; margin-bottom: 30px;">
            <div class="mb-3">
                <label class="form-label">Zadejte město:</label>
                <input type="text" name="city" value="<?=$_GET["city"]; ?>" class="form-control">
            </div>

            <button type="submit" class="btn btn-primary">Zobrazit počasí</button>
        </form>

        <div class="">
            <?php 
                echo "<p>$weather</p>"; 
                echo "<p>$teploty</p>";
                echo "<p>GPS: $poloha - <a href='https://www.google.com/maps/@$poloha,13z' target='_blank'>mapa</a></p>";
            ?>
        </div>
    </div>
</body>
</html>
