<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zaměstnanci</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style> 
    body {
         background-color: NavajoWhite; 
        } 
    </style>
</head>
<body>
    <div class="container">
        <h2 class="mt-4">Seznam Zaměstnanců</h2>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Jméno</th>
                    <th>Pracovní pozice</th>
                    <th>Plat</th>
                    <th>Nástupní rok</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $filename = 'zamci.csv';
                $zamestnanci = []; 
                $currentYear = date('Y');

                if (($handle = fopen($filename, 'r')) !== false) {
                    $header = fgetcsv($handle, 1000, ';'); 

                    while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                        $zamestnanci[] = [
                            'jmeno' => $data[0],
                            'pozice' => $data[1],
                            'plat' => (int)$data[2],
                            'rok' => (int)$data[3]
                        ];

                        echo "<tr>
                                <td>{$data[0]}</td>
                                <td>{$data[1]}</td>
                                <td>{$data[2]}</td>
                                <td>{$data[3]}</td>
                              </tr>";
                    }
                    fclose($handle);
                } 
                ?>
            </tbody>
        </table>

        <?php
        if (!empty($zamestnanci)) {
            $nejvyssiPlat = max(array_column($zamestnanci, 'plat'));
            $richZamestnanec = array_filter($zamestnanci, function($z) use ($nejvyssiPlat) {
                return $z['plat'] === $nejvyssiPlat;
            });
            $richZamestnanec = reset($richZamestnanec); 

            echo "<h3>Zaměstnanec s nejvyšším platem:</h3>";
            echo "<p><strong>Jméno:</strong> {$richZamestnanec['jmeno']}, <br><strong>Pozice:</strong> {$richZamestnanec['pozice']}</p>";

            echo "<h3>Zaměstnanci pracující více než 10 let:</h3>";
            $dlouhoZamestnanci = array_filter($zamestnanci, function($z) use ($currentYear) {
                return ($currentYear - $z['rok']) > 10;
            });

            if (!empty($dlouhoZamestnanci)) {
                echo "<ul>";
                foreach ($dlouhoZamestnanci as $z) {
                    echo "<li><strong>Jméno:</strong> {$z['jmeno']},<br> <strong>Pozice:</strong> {$z['pozice']}</li>";
                }
                echo "</ul>";
            } else {
                echo "<p>Žádný zaměstnanec nepracuje více než 10 let.</p>";
            }

            $prumernyPlat = array_sum(array_column($zamestnanci, 'plat')) / count($zamestnanci);
            echo "<h3>Průměrný plat:</h3>";
            echo "<p>" . number_format($prumernyPlat, 2, ',', ' ') . " Kč</p>";
        }
        ?>      
    </div>       
</body>
</html>
